unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Dib, Wave, WaveMixer, DIBDrawingSurface, ComCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Wave1: TWave;
    dlgOpen: TOpenDialog;
    Button2: TButton;
    WaveMixer1: TWaveMixer;
    lbWaves: TListBox;
    Button3: TButton;
    Label1: TLabel;
    Label2: TLabel;
    trackVolume: TTrackBar;
    scrollPanning: TScrollBar;
    Button4: TButton;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure lbWavesClick(Sender: TObject);
    procedure trackVolumeChange(Sender: TObject);
    procedure scrollPanningChange(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button2Click(Sender: TObject);
begin
  if lbWaves.ItemIndex >= 0 then
     WaveMixer1.PlayBuffer( WaveMixer1.BufferByName[lbWaves.Items[lbWaves.ItemIndex]], FALSE );
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  sName: string;
  nPos: integer;
begin
  if dlgOpen.Execute then
     begin
        sName := dlgOpen.FileName;
        nPos := Pos( '\', sName );
        while nPos > 0 do
           begin
              sName := Copy( sName, nPos + 1, Length( sName ) - nPos );
              nPos := Pos( '\', sName );
           end;
        nPos := Pos( '.', sName );
        if nPos > 0 then
           sName := Copy( sName, 1, nPos - 1 );
        if WaveMixer1.BufferByName[sName] = nil then
           begin
              Wave1.LoadFromFile( dlgOpen.FileName );
              WaveMixer1.AddBuffer( sName, Wave1 );
              lbWaves.Items.Add( sName );
           end;
     end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  if lbWaves.ItemIndex >= 0 then
     begin
        WaveMixer1.RemoveBuffer( WaveMixer1.BufferByName[lbWaves.Items[lbWaves.ItemIndex]] );
        lbWaves.Items.Delete( lbWaves.ItemIndex );
     end;
end;

procedure TForm1.lbWavesClick(Sender: TObject);
begin
  with WaveMixer1.BufferByName[lbWaves.Items[lbWaves.ItemIndex]] do
     begin
        trackVolume.Position := Volume + 10000;
        scrollPanning.Position := Panning;
     end;
end;

procedure TForm1.trackVolumeChange(Sender: TObject);
begin
  if lbWaves.ItemIndex >= 0 then
     WaveMixer1.BufferByName[lbWaves.Items[lbWaves.ItemIndex]].Volume := trackVolume.Position - 10000;
end;

procedure TForm1.scrollPanningChange(Sender: TObject);
begin
  if lbWaves.ItemIndex >= 0 then
     WaveMixer1.BufferByName[lbWaves.Items[lbWaves.ItemIndex]].Panning := scrollPanning.Position;
end;

procedure TForm1.Button4Click(Sender: TObject);
var
  sName: string;
begin
  if lbWaves.ItemIndex >= 0 then
     if InputQuery( 'Wave Name', 'Enter a new name for the cloned Wave:', sName ) then
        begin
           WaveMixer1.CloneBuffer( WaveMixer1.BufferByName[lbWaves.Items[lbWaves.ItemIndex]], sName );
           lbWaves.Items.Add( sName );
        end;
end;

end.
